PROCEDURE Make1CableFromMany;
{DEBUG}

CONST
	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_CONST 2020.px}
	
VAR
	{$INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_VARS.px}
	VertArray			:ARRAY[1..50] OF VECTOR;
	TotalVerts			:INTEGER;
	SelectedCable		:HANDLE;
	CableArray			:ARRAY[1..9] OF HANDLE;
	CableCt				:INTEGER;
	OldSourceUID		:STRING;
	CurrCable			:HANDLE;
	Str1					:STRING;
	Str2					:STRING;
	Str3					:STRING;
	NewStartX, NewStartY	:REAL;
	NewCable				:HANDLE;
	NewPath				:HANDLE;
	NewBOName			:STRING;
	NewHeadSym			:STRING;
	NewPartNum			:INTEGER;
	NextPart				:STRING;
	NextPartVal			:REAL;
	OldID					:STRING;
	PartNum				:INTEGER;
	PartVal				:REAL;
	PartValStr			:STRING;
	OK						:BOOLEAN;

{==============================================================}

	PROCEDURE CollectVertices(theCable:HANDLE);

	VAR
		vertNum : INTEGER;
		vert : VECTOR;
		startX, startY : REAL;
		index : INTEGER;
		cblPath : HANDLE;
		
	BEGIN
		GetSymLoc(theCable, startX, startY);

		cblPath := GetCustomObjectPath(theCable);
		vertNum := GetVertNum(cblPath);
		FOR index := 1 TO vertNum DO
			BEGIN
				TotalVerts := TotalVerts + 1;
				GetPolyPt(cblPath, index, VertArray[TotalVerts].x, VertArray[TotalVerts].y);
				VertArray[TotalVerts].x := VertArray[TotalVerts].x + startX;
				VertArray[TotalVerts].y := VertArray[TotalVerts].y + startY;
				(*Locus(VertArray[TotalVerts].x, VertArray[TotalVerts].y);*)
			END;
	END; {PROCEDURE CollectVertices}

{==============================================================}

BEGIN
	TotalVerts := 0;
	SelectedCable := FSActLayer;
	OldSourceUID := GetRField(SelectedCable, kAPMultiRecName, 'SourceUID');
	OldID := GetRField(SelectedCable, kAPMultiRecName, 'CableID');
	CurrCable := GetObject(OldSourceUID);
	GetSymLoc(CurrCable, NewStartX, NewStartY);
	
	IF CurrCable <> NIL THEN
		BEGIN
			CableCt := 1;
			CollectVertices(CurrCable);
			CableArray[CableCt] := CurrCable;
			CurrCable := GetObject(GetRField(CurrCable, kAPMultiRecName, 'TargetUID'));
			WHILE CurrCable <> NIL DO
				BEGIN
					CableCt := CableCt + 1;
					CableArray[CableCt] := CurrCable;
					CollectVertices(CurrCable);
					CurrCable := GetObject(GetRField(CurrCable, kAPMultiRecName, 'TargetUID'));
					NewBOName := GetRField(CurrCable, kAPMultiRecName, 'Break Out Type');
					NewHeadSym := GetRField(CurrCable, kAPMultiRecName, 'HeadSym');
				END;
		END; {IF CurrCable <> NIL}		
	BeginPoly;
		FOR Index := 1 TO TotalVerts DO
			BEGIN
				(*AddPoint(VertArray[Index].x + NewStartX, VertArray[Index].y + NewStartY);*)
				AddPoint(VertArray[Index].x, VertArray[Index].y);
			END;
	EndPoly;
	NewPath := LNewObj;
	SetFPat(NewPath,0);
		
	NewCable := CreateCustomObjectPathN(kAPMultiRecName,NewPath,NIL);
	SetRField(NewCable, kAPMultiRecName, 'CableID', OldID);
	SetRField(NewCable, kAPMultiRecName, 'Break Out Type', NewBOName);
	SetRField(NewCable, kAPMultiRecName, 'HeadSym', NewHeadSym);
	
	PartNum := 1;
	NewPartNum := 0;
	Index := 1;
	WHILE (Index <= CableCt) DO
		BEGIN
			CurrCable := CableArray[Index];
			NewPartNum := NewPartNum + 1;
			PartValStr := GetRField(CurrCable, kAPMultiRecName, 'Part 1');
			OK := ValidNumStr(PartValStr, PartVal);
			SetRField(NewCable, kAPMultiRecName, CONCAT('Part ', NewPartNum), Num2StrF(PartVal));
			
			Str1 := GetRField(CurrCable, kAPMultiRecName, 'PartVert1');
			OK := ValidNumStr(Str1, PartVal);
			SetRField(NewCable, kAPMultiRecName, CONCAT('PartVert', NewPartNum), Num2StrF(PartVal));

			Str1 := GetRField(CurrCable, kAPMultiRecName, 'CblBrk1');
			OK := ValidNumStr(Str1, PartVal);
			SetRField(NewCable, kAPMultiRecName, CONCAT('CblBrk', NewPartNum), Num2StrF(PartVal));
(*
			NextPart := GetRField(CableArray[Index+1], kAPMultiRecName, 'CblBrk2');
			OK := ValidNumStr(NextPart, NextPartVal);
			IF NextPartVal > 0 THEN
				SetRField(NewCable, kAPMultiRecName, CONCAT('CblBrk', NewPartNum), Num2StrF(PartVal));
*)
			
			PartNum := 2;
			PartValStr := GetRField(CurrCable, kAPMultiRecName, 'Part 2');
			OK := ValidNumStr(PartValStr, PartVal);

			WHILE (PartVal <> 0) DO
				BEGIN
					NewPartNum := NewPartNum + 1;
					IF NewPartNum < 10 THEN
						BEGIN
							SetRField(NewCable, kAPMultiRecName, CONCAT('Part ', NewPartNum), Num2StrF(PartVal));
							
							Str1 := GetRField(CurrCable, kAPMultiRecName, CONCAT('PartVert', PartNum));
							OK := ValidNumStr(Str1, PartVal);
							SetRField(NewCable, kAPMultiRecName, CONCAT('PartVert', NewPartNum), Num2StrF(PartVal));

							Str1 := GetRField(CurrCable, kAPMultiRecName, CONCAT('CblBrk', PartNum));
							OK := ValidNumStr(Str1, PartVal);
							SetRField(NewCable, kAPMultiRecName, CONCAT('CblBrk', NewPartNum), Num2StrF(PartVal));

							PartNum := PartNum + 1;
							Str1 := CONCAT('Part ', PartNum);
							PartValStr := GetRField(CurrCable, kAPMultiRecName, Str1);
							OK := ValidNumStr(PartValStr, PartVal);
						END; {IF NewPartNum < 10}
				END; {GetRField(CurrCable, kAPMultiRecName}
			Index := Index + 1;
		END; {WHILE (Index <= CableCt) }
		
		NewPartNum := CableCt + 1;
		IF ValidNumStr(GetRField(NewCable, kAPMultiRecName, CONCAT('Part ',NewPartNum)), NextPartVal) THEN
			BEGIN
				IF NextPartVal < 1 THEN
					BEGIN
						SetRField(NewCable, kAPMultiRecName, CONCAT('CblBrk', CableCt), '0');
					END;
			END; {IF ValidNumStr(GetRField(NewCable}
	ResetObject(NewCable);
	FOR Index := 1 TO CableCt DO
		DelObject(CableArray[Index]);
	DSelectAll;
	SetName(NewCable, OldSourceUID);
	SetSelect(NewCable);
		
END;
RUN(Make1CableFromMany);

